/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.GpuFence;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_10219;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_10865;
import net.minecraft.class_11219;
import net.minecraft.class_11282;
import net.minecraft.class_12136;
import net.minecraft.class_12289;
import net.minecraft.class_156;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_6177;
import net.minecraft.class_7576;
import net.minecraft.class_8623;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.jspecify.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

@class_6177
public class RenderSystem {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    public static final int PROJECTION_MATRIX_UBO_SIZE = new Std140SizeCalculator().putMat4f().get();
    private static @Nullable Thread renderThread;
    private static @Nullable GpuDevice DEVICE;
    private static double lastDrawTime;
    private static final class_5590 sharedSequential;
    private static final class_5590 sharedSequentialQuad;
    private static final class_5590 sharedSequentialLines;
    private static class_10366 projectionType;
    private static class_10366 savedProjectionType;
    private static final Matrix4fStack modelViewStack;
    private static @Nullable GpuBufferSlice shaderFog;
    private static @Nullable GpuBufferSlice shaderLightDirections;
    private static @Nullable GpuBufferSlice projectionMatrixBuffer;
    private static @Nullable GpuBufferSlice savedProjectionMatrixBuffer;
    private static String apiDescription;
    private static final AtomicLong pollEventsWaitStart;
    private static final AtomicBoolean pollingEvents;
    private static final class_8623<class_10827> PENDING_FENCES;
    public static @Nullable GpuTextureView outputColorTextureOverride;
    public static @Nullable GpuTextureView outputDepthTextureOverride;
    private static @Nullable GpuBuffer globalSettingsUniform;
    private static @Nullable class_11282 dynamicUniforms;
    private static final class_11219 scissorStateForRenderTypeDraws;
    private static class_12136 samplerCache;

    public static class_12136 getSamplerCache() {
        return samplerCache;
    }

    public static void initRenderThread() {
        if (renderThread != null) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static void assertOnRenderThread() {
        if (!RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    private static IllegalStateException constructThreadException() {
        return new IllegalStateException("Rendersystem called from wrong thread");
    }

    private static void pollEvents() {
        pollEventsWaitStart.set(class_156.method_658());
        pollingEvents.set(true);
        GLFW.glfwPollEvents();
        pollingEvents.set(false);
    }

    public static boolean isFrozenAtPollEvents() {
        return pollingEvents.get() && class_156.method_658() - pollEventsWaitStart.get() > 200L;
    }

    public static void flipFrame(class_1041 $$0, @Nullable class_10219 $$1) {
        RenderSystem.pollEvents();
        class_289.method_1348().method_60828();
        GLFW.glfwSwapBuffers((long)$$0.method_4490());
        if ($$1 != null) {
            $$1.method_64233();
        }
        dynamicUniforms.method_71105();
        class_310.method_1551().field_1769.method_71118();
        RenderSystem.pollEvents();
    }

    public static void limitDisplayFPS(int $$0) {
        double $$1 = lastDrawTime + 1.0 / (double)$$0;
        double $$2 = GLFW.glfwGetTime();
        while ($$2 < $$1) {
            GLFW.glfwWaitEventsTimeout((double)($$1 - $$2));
            $$2 = GLFW.glfwGetTime();
        }
        lastDrawTime = $$2;
    }

    public static void setShaderFog(GpuBufferSlice $$0) {
        shaderFog = $$0;
    }

    public static @Nullable GpuBufferSlice getShaderFog() {
        return shaderFog;
    }

    public static void setShaderLights(GpuBufferSlice $$0) {
        shaderLightDirections = $$0;
    }

    public static @Nullable GpuBufferSlice getShaderLights() {
        return shaderLightDirections;
    }

    public static void enableScissorForRenderTypeDraws(int $$0, int $$1, int $$2, int $$3) {
        scissorStateForRenderTypeDraws.method_70814($$0, $$1, $$2, $$3);
    }

    public static void disableScissorForRenderTypeDraws() {
        scissorStateForRenderTypeDraws.method_70813();
    }

    public static class_11219 getScissorStateForRenderTypeDraws() {
        return scissorStateForRenderTypeDraws;
    }

    public static String getBackendDescription() {
        return String.format(Locale.ROOT, "LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        return apiDescription;
    }

    public static class_7576.class_7577 initBackendSystem() {
        return GLX._initGlfw()::getAsLong;
    }

    public static void initRenderer(long $$0, int $$1, boolean $$2, class_12289 $$3, boolean $$4) {
        DEVICE = new class_10865($$0, $$1, $$2, $$3, $$4);
        apiDescription = RenderSystem.getDevice().getImplementationInformation();
        dynamicUniforms = new class_11282();
        samplerCache.method_75292();
    }

    public static void setErrorCallback(GLFWErrorCallbackI $$0) {
        GLX._setGlfwErrorCallback($$0);
    }

    public static void setupDefaultState() {
        modelViewStack.clear();
    }

    public static void setProjectionMatrix(GpuBufferSlice $$0, class_10366 $$1) {
        RenderSystem.assertOnRenderThread();
        projectionMatrixBuffer = $$0;
        projectionType = $$1;
    }

    public static void backupProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        savedProjectionMatrixBuffer = projectionMatrixBuffer;
        savedProjectionType = projectionType;
    }

    public static void restoreProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        projectionMatrixBuffer = savedProjectionMatrixBuffer;
        projectionType = savedProjectionType;
    }

    public static @Nullable GpuBufferSlice getProjectionMatrixBuffer() {
        RenderSystem.assertOnRenderThread();
        return projectionMatrixBuffer;
    }

    public static Matrix4f getModelViewMatrix() {
        RenderSystem.assertOnRenderThread();
        return modelViewStack;
    }

    public static Matrix4fStack getModelViewStack() {
        RenderSystem.assertOnRenderThread();
        return modelViewStack;
    }

    public static class_5590 getSequentialBuffer(VertexFormat.class_5596 $$0) {
        RenderSystem.assertOnRenderThread();
        return switch ($$0) {
            case VertexFormat.class_5596.field_27382 -> sharedSequentialQuad;
            case VertexFormat.class_5596.field_27377 -> sharedSequentialLines;
            default -> sharedSequential;
        };
    }

    public static void setGlobalSettingsUniform(GpuBuffer $$0) {
        globalSettingsUniform = $$0;
    }

    public static @Nullable GpuBuffer getGlobalSettingsUniform() {
        return globalSettingsUniform;
    }

    public static class_10366 getProjectionType() {
        RenderSystem.assertOnRenderThread();
        return projectionType;
    }

    public static void queueFencedTask(Runnable $$0) {
        PENDING_FENCES.addLast(new class_10827($$0, RenderSystem.getDevice().createCommandEncoder().createFence()));
    }

    public static void executePendingTasks() {
        class_10827 $$0 = PENDING_FENCES.peekFirst();
        while ($$0 != null) {
            if ($$0.comp_3786.awaitCompletion(0L)) {
                try {
                    $$0.comp_3785.run();
                }
                finally {
                    $$0.comp_3786.close();
                }
                PENDING_FENCES.removeFirst();
                $$0 = PENDING_FENCES.peekFirst();
                continue;
            }
            return;
        }
    }

    public static GpuDevice getDevice() {
        if (DEVICE == null) {
            throw new IllegalStateException("Can't getDevice() before it was initialized");
        }
        return DEVICE;
    }

    public static @Nullable GpuDevice tryGetDevice() {
        return DEVICE;
    }

    public static class_11282 getDynamicUniforms() {
        if (dynamicUniforms == null) {
            throw new IllegalStateException("Can't getDynamicUniforms() before device was initialized");
        }
        return dynamicUniforms;
    }

    public static void bindDefaultUniforms(RenderPass $$0) {
        GpuBufferSlice $$4;
        GpuBuffer $$3;
        GpuBufferSlice $$2;
        GpuBufferSlice $$1 = RenderSystem.getProjectionMatrixBuffer();
        if ($$1 != null) {
            $$0.setUniform("Projection", $$1);
        }
        if (($$2 = RenderSystem.getShaderFog()) != null) {
            $$0.setUniform("Fog", $$2);
        }
        if (($$3 = RenderSystem.getGlobalSettingsUniform()) != null) {
            $$0.setUniform("Globals", $$3);
        }
        if (($$4 = RenderSystem.getShaderLights()) != null) {
            $$0.setUniform("Lighting", $$4);
        }
    }

    static {
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new class_5590(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new class_5590(4, 6, ($$0, $$1) -> {
            $$0.accept($$1);
            $$0.accept($$1 + 1);
            $$0.accept($$1 + 2);
            $$0.accept($$1 + 2);
            $$0.accept($$1 + 3);
            $$0.accept($$1);
        });
        sharedSequentialLines = new class_5590(4, 6, ($$0, $$1) -> {
            $$0.accept($$1);
            $$0.accept($$1 + 1);
            $$0.accept($$1 + 2);
            $$0.accept($$1 + 3);
            $$0.accept($$1 + 2);
            $$0.accept($$1 + 1);
        });
        projectionType = class_10366.field_54953;
        savedProjectionType = class_10366.field_54953;
        modelViewStack = new Matrix4fStack(16);
        shaderFog = null;
        apiDescription = "Unknown";
        pollEventsWaitStart = new AtomicLong();
        pollingEvents = new AtomicBoolean(false);
        PENDING_FENCES = new class_8623();
        scissorStateForRenderTypeDraws = new class_11219();
        samplerCache = new class_12136();
    }

    public static final class class_5590 {
        private final int field_27332;
        private final int field_27333;
        private final class_5591 field_27334;
        private @Nullable GpuBuffer field_54299;
        private VertexFormat.class_5595 field_27336 = VertexFormat.class_5595.field_27372;
        private int field_27337;

        class_5590(int $$0, int $$1, class_5591 $$2) {
            this.field_27332 = $$0;
            this.field_27333 = $$1;
            this.field_27334 = $$2;
        }

        public boolean method_43409(int $$0) {
            return $$0 <= this.field_27337;
        }

        public GpuBuffer method_68274(int $$0) {
            this.method_31920($$0);
            return this.field_54299;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void method_31920(int $$0) {
            if (this.method_43409($$0)) {
                return;
            }
            $$0 = class_3532.method_28139($$0 * 2, this.field_27333);
            LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.field_27337, (Object)$$0);
            int $$1 = $$0 / this.field_27333;
            int $$2 = $$1 * this.field_27332;
            VertexFormat.class_5595 $$3 = VertexFormat.class_5595.method_31972($$2);
            int $$4 = class_3532.method_28139($$0 * $$3.field_27375, 4);
            ByteBuffer $$5 = MemoryUtil.memAlloc((int)$$4);
            try {
                this.field_27336 = $$3;
                IntConsumer $$6 = this.method_31922($$5);
                for (int $$7 = 0; $$7 < $$0; $$7 += this.field_27333) {
                    this.field_27334.accept($$6, $$7 * this.field_27332 / this.field_27333);
                }
                $$5.flip();
                if (this.field_54299 != null) {
                    this.field_54299.close();
                }
                this.field_54299 = RenderSystem.getDevice().createBuffer(() -> "Auto Storage index buffer", 64, $$5);
            }
            finally {
                MemoryUtil.memFree((Buffer)$$5);
            }
            this.field_27337 = $$0;
        }

        private IntConsumer method_31922(ByteBuffer $$0) {
            switch (this.field_27336) {
                case field_27372: {
                    return $$1 -> $$0.putShort((short)$$1);
                }
            }
            return $$0::putInt;
        }

        public VertexFormat.class_5595 method_31924() {
            return this.field_27336;
        }

        static interface class_5591 {
            public void accept(IntConsumer var1, int var2);
        }
    }

    static final class class_10827
    extends Record {
        final Runnable comp_3785;
        final GpuFence comp_3786;

        class_10827(Runnable $$0, GpuFence $$1) {
            this.comp_3785 = $$0;
            this.comp_3786 = $$1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{class_10827.class, "callback;fence", "comp_3785", "comp_3786"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{class_10827.class, "callback;fence", "comp_3785", "comp_3786"}, this);
        }

        @Override
        public final boolean equals(Object $$0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{class_10827.class, "callback;fence", "comp_3785", "comp_3786"}, this, $$0);
        }

        public Runnable comp_3785() {
            return this.comp_3785;
        }

        public GpuFence comp_3786() {
            return this.comp_3786;
        }
    }
}

