/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.bytecode.builder;

import net.lenni0451.reflect.bytecode.BytecodeUtils;
import net.lenni0451.reflect.bytecode.builder.BytecodeBuilder;
import net.lenni0451.reflect.bytecode.wrapper.BytecodeLabel;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface MethodBuilder {
    public MethodBuilder return_();

    public MethodBuilder ireturn();

    public MethodBuilder lreturn();

    public MethodBuilder freturn();

    public MethodBuilder dreturn();

    public MethodBuilder areturn();

    default public MethodBuilder return_(Class<?> type) {
        if (Void.TYPE.equals(type)) {
            return this.return_();
        }
        if (Boolean.TYPE.equals(type) || Byte.TYPE.equals(type) || Character.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type)) {
            return this.ireturn();
        }
        if (Long.TYPE.equals(type)) {
            return this.lreturn();
        }
        if (Float.TYPE.equals(type)) {
            return this.freturn();
        }
        if (Double.TYPE.equals(type)) {
            return this.dreturn();
        }
        return this.areturn();
    }

    public MethodBuilder dup();

    public MethodBuilder dupX1();

    public MethodBuilder pop();

    public MethodBuilder aaload();

    public MethodBuilder aastore();

    public MethodBuilder aconstNull();

    public MethodBuilder athrow();

    public MethodBuilder i2l();

    public MethodBuilder iconstM1();

    public MethodBuilder iconst0();

    public MethodBuilder iconst1();

    public MethodBuilder iconst2();

    public MethodBuilder iconst3();

    public MethodBuilder iconst4();

    public MethodBuilder iconst5();

    public MethodBuilder lconst0();

    public MethodBuilder lconst1();

    public MethodBuilder fconst0();

    public MethodBuilder fconst1();

    public MethodBuilder fconst2();

    public MethodBuilder dconst0();

    public MethodBuilder dconst1();

    public MethodBuilder sipush(int var1);

    public MethodBuilder bipush(int var1);

    default public MethodBuilder intPush(int i) {
        if (i == -1) {
            return this.iconstM1();
        }
        if (i == 0) {
            return this.iconst0();
        }
        if (i == 1) {
            return this.iconst1();
        }
        if (i == 2) {
            return this.iconst2();
        }
        if (i == 3) {
            return this.iconst3();
        }
        if (i == 4) {
            return this.iconst4();
        }
        if (i == 5) {
            return this.iconst5();
        }
        if (i >= -128 && i <= 127) {
            return this.bipush(i);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return this.sipush(i);
        }
        return this.ldc(i);
    }

    public MethodBuilder iload(int var1);

    public MethodBuilder lload(int var1);

    public MethodBuilder fload(int var1);

    public MethodBuilder dload(int var1);

    public MethodBuilder aload(int var1);

    default public MethodBuilder load(Class<?> type, int varIndex) {
        if (Boolean.TYPE.equals(type) || Byte.TYPE.equals(type) || Character.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type)) {
            return this.iload(varIndex);
        }
        if (Long.TYPE.equals(type)) {
            return this.lload(varIndex);
        }
        if (Float.TYPE.equals(type)) {
            return this.fload(varIndex);
        }
        if (Double.TYPE.equals(type)) {
            return this.dload(varIndex);
        }
        return this.aload(varIndex);
    }

    public MethodBuilder istore(int var1);

    public MethodBuilder lstore(int var1);

    public MethodBuilder fstore(int var1);

    public MethodBuilder dstore(int var1);

    public MethodBuilder astore(int var1);

    default public MethodBuilder store(Class<?> type, int varIndex) {
        if (Boolean.TYPE.equals(type) || Byte.TYPE.equals(type) || Character.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type)) {
            return this.istore(varIndex);
        }
        if (Long.TYPE.equals(type)) {
            return this.lstore(varIndex);
        }
        if (Float.TYPE.equals(type)) {
            return this.fstore(varIndex);
        }
        if (Double.TYPE.equals(type)) {
            return this.dstore(varIndex);
        }
        return this.astore(varIndex);
    }

    public MethodBuilder new_(String var1);

    public MethodBuilder checkcast(String var1);

    public MethodBuilder anewarray(String var1);

    default public MethodBuilder box(Class<?> primitive) {
        Class<?> boxed = BytecodeUtils.boxed(primitive);
        if (boxed != primitive) {
            this.invokestatic(BytecodeUtils.slash(boxed), "valueOf", BytecodeUtils.mdesc(boxed, primitive), false);
        }
        return this;
    }

    default public MethodBuilder unbox(Class<?> primitive) {
        Class<?> boxed = BytecodeUtils.boxed(primitive);
        if (boxed != primitive) {
            this.invokevirtual(BytecodeUtils.slash(boxed), primitive.getSimpleName() + "Value", BytecodeUtils.mdesc(primitive, new Class[0]));
        }
        return this;
    }

    public MethodBuilder putfield(String var1, String var2, String var3);

    public MethodBuilder putstatic(String var1, String var2, String var3);

    public MethodBuilder getfield(String var1, String var2, String var3);

    public MethodBuilder getstatic(String var1, String var2, String var3);

    public MethodBuilder invokespecial(String var1, String var2, String var3, boolean var4);

    public MethodBuilder invokeinterface(String var1, String var2, String var3);

    public MethodBuilder invokevirtual(String var1, String var2, String var3);

    public MethodBuilder invokestatic(String var1, String var2, String var3, boolean var4);

    public MethodBuilder ifne(BytecodeLabel var1);

    public MethodBuilder ifnonnull(BytecodeLabel var1);

    public MethodBuilder goto_(BytecodeLabel var1);

    public BytecodeLabel newLabel();

    public MethodBuilder label(BytecodeLabel var1);

    public MethodBuilder ldc(Object var1);

    default public MethodBuilder typeLdc(BytecodeBuilder builder, Class<?> clazz) {
        Class<?> boxed = BytecodeUtils.boxed(clazz);
        if (boxed == clazz) {
            this.ldc(builder.type(BytecodeUtils.desc(clazz)));
        } else {
            this.getstatic(BytecodeUtils.slash(boxed), "TYPE", BytecodeUtils.desc(Class.class));
        }
        return this;
    }

    public MethodBuilder tryCatch(BytecodeLabel var1, BytecodeLabel var2, BytecodeLabel var3, String var4);

    public MethodBuilder maxs(int var1, int var2);
}

