/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.accessor;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.lenni0451.reflect.bytecode.BytecodeUtils;
import net.lenni0451.reflect.bytecode.builder.BytecodeBuilder;
import net.lenni0451.reflect.bytecode.builder.ClassBuilder;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class AccessorUtils {
    private static final String VALID_MEMBER_NAME = "[^a-zA-Z0-9_$]";

    AccessorUtils() {
    }

    public static String makeAccessorName(String type, Class<?> owner, String memberName) {
        StringBuilder name = new StringBuilder();
        Package pkg = owner.getPackage();
        if (pkg != null) {
            name.append(BytecodeUtils.slash(pkg.getName())).append('/');
        }
        name.append(owner.getSimpleName().replaceAll(VALID_MEMBER_NAME, "_")).append('$');
        name.append(memberName.replaceAll(VALID_MEMBER_NAME, "_")).append('$');
        name.append(type);
        return name.toString();
    }

    public static void addConstructor(BytecodeBuilder builder, ClassBuilder cb, @Nullable Supplier<Class<?>> instanceType, boolean isStatic) {
        if (isStatic || instanceType == null) {
            cb.method(builder.opcode("ACC_PUBLIC"), "<init>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), null, null, mb -> mb.aload(0).invokespecial(BytecodeUtils.slash(Object.class), "<init>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), false).return_().maxs(1, 1));
        } else {
            cb.field(builder.opcode("ACC_PRIVATE", "ACC_FINAL"), "instance", BytecodeUtils.desc(instanceType.get()), null, null, fb -> {});
            cb.method(builder.opcode("ACC_PUBLIC"), "<init>", BytecodeUtils.mdesc(Void.TYPE, instanceType.get()), null, null, mb -> mb.aload(0).invokespecial(BytecodeUtils.slash(Object.class), "<init>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), false).aload(0).aload(1).putfield(cb.getName(), "instance", BytecodeUtils.desc((Class)instanceType.get())).return_().maxs(2, 2));
        }
    }
}

