/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.localcapture;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.lenni0451.reflect.Classes;
import net.lenni0451.reflect.JVMConstants;
import net.lenni0451.reflect.JavaBypass;
import net.lenni0451.reflect.exceptions.MethodNotFoundException;
import net.lenni0451.reflect.localcapture.LocalStackFrame;
import net.lenni0451.reflect.localcapture.LocalStackFrameImpl;
import net.lenni0451.reflect.utils.FieldInitializer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LocalCapturer {
    private static final Class<?> liveStackFrame = Classes.forName(JVMConstants.CLASS_LiveStackFrame);
    private static final StackWalker stackWalker = FieldInitializer.reqInit(() -> {
        MethodHandle getStackWalker = JavaBypass.TRUSTED_LOOKUP.findStatic(liveStackFrame, JVMConstants.METHOD_LiveStackFrame_getStackWalker, MethodType.methodType(StackWalker.class, Set.class));
        return getStackWalker.invokeExact(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE));
    }, () -> new MethodNotFoundException(liveStackFrame.getName(), JVMConstants.METHOD_LiveStackFrame_getStackWalker, StackWalker.class));

    public static void forEach(Consumer<LocalStackFrame> consumer) {
        LocalCapturer.walk(s -> {
            s.skip(1L).forEach(consumer);
            return null;
        });
    }

    public static <T> T walk(Function<Stream<LocalStackFrame>, T> function) {
        return (T)stackWalker.walk(s -> function.apply(s.skip(1L).map(LocalStackFrameImpl::new)));
    }

    public static LocalStackFrame[] getStackFrames() {
        return LocalCapturer.walk(s -> (LocalStackFrame[])s.toArray(LocalStackFrame[]::new));
    }
}

