/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.impl.client.indigo.Indigo;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoConfig;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.LightDataProvider;
import net.minecraft.class_11515;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_4588;
import net.minecraft.class_9848;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractTerrainRenderContext
extends AbstractRenderContext {
    protected final BlockRenderInfo blockInfo = new BlockRenderInfo();
    protected final LightDataProvider lightDataProvider;
    private final AoCalculator aoCalc;
    private int cachedTintIndex = -1;
    private int cachedTint;
    private final class_2338.class_2339 lightPos = new class_2338.class_2339();

    protected AbstractTerrainRenderContext() {
        this.lightDataProvider = this.createLightDataProvider(this.blockInfo);
        this.aoCalc = new AoCalculator(this.blockInfo, this.lightDataProvider);
    }

    protected abstract LightDataProvider createLightDataProvider(BlockRenderInfo var1);

    protected abstract class_4588 getVertexConsumer(class_11515 var1);

    protected void prepare(class_2338 pos, class_2680 state) {
        this.blockInfo.prepareForBlock(pos, state);
        this.aoCalc.clear();
        this.cachedTintIndex = -1;
    }

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        if (this.blockInfo.shouldCullSide(quad.cullFace())) {
            return;
        }
        boolean ao = this.blockInfo.effectiveAo(quad.ambientOcclusion());
        boolean vanillaShade = quad.shadeMode() == ShadeMode.VANILLA;
        class_4588 vertexConsumer = this.getVertexConsumer(this.blockInfo.effectiveRenderLayer(quad.renderLayer()));
        this.tintQuad(quad);
        this.shadeQuad(quad, ao, quad.emissive(), vanillaShade);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex != -1) {
            int tint;
            if (tintIndex == this.cachedTintIndex) {
                tint = this.cachedTint;
            } else {
                this.cachedTint = tint = this.blockInfo.blockColor(tintIndex);
                this.cachedTintIndex = tintIndex;
            }
            for (int i = 0; i < 4; ++i) {
                quad.color(i, class_9848.method_61322((int)quad.color(i), (int)tint));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean ao, boolean emissive, boolean vanillaShade) {
        if (ao) {
            this.aoCalc.compute(quad, vanillaShade);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, class_9848.method_61321((int)quad.color(i), (float)this.aoCalc.ao[i]));
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, class_9848.method_61321((int)quad.color(i), (float)this.aoCalc.ao[i]));
                    quad.lightmap(i, ColorHelper.maxLight(quad.lightmap(i), this.aoCalc.light[i]));
                }
            }
        } else {
            this.shadeFlatQuad(quad, vanillaShade);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                int light = this.flatLight(quad);
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, ColorHelper.maxLight(quad.lightmap(i), light));
                }
            }
        }
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad, boolean vanillaShade) {
        block9: {
            boolean hasShade;
            block7: {
                float faceShade;
                block10: {
                    block8: {
                        hasShade = quad.diffuseShade();
                        if ((Indigo.AMBIENT_OCCLUSION_MODE != AoConfig.HYBRID || vanillaShade) && Indigo.AMBIENT_OCCLUSION_MODE != AoConfig.ENHANCED) break block7;
                        if (!quad.hasAllVertexNormals()) break block8;
                        for (int i = 0; i < 4; ++i) {
                            float shade = this.normalShade(quad.normalX(i), quad.normalY(i), quad.normalZ(i), hasShade);
                            quad.color(i, class_9848.method_61321((int)quad.color(i), (float)shade));
                        }
                        break block9;
                    }
                    if ((quad.geometryFlags() & 2) != 0) {
                        faceShade = this.blockInfo.blockView.method_24852(quad.lightFace(), hasShade);
                    } else {
                        Vector3fc faceNormal = quad.faceNormal();
                        faceShade = this.normalShade(faceNormal.x(), faceNormal.y(), faceNormal.z(), hasShade);
                    }
                    if (!quad.hasVertexNormals()) break block10;
                    for (int i = 0; i < 4; ++i) {
                        float shade = quad.hasNormal(i) ? this.normalShade(quad.normalX(i), quad.normalY(i), quad.normalZ(i), hasShade) : faceShade;
                        quad.color(i, class_9848.method_61321((int)quad.color(i), (float)shade));
                    }
                    break block9;
                }
                if (faceShade == 1.0f) break block9;
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, class_9848.method_61321((int)quad.color(i), (float)faceShade));
                }
                break block9;
            }
            float faceShade = this.blockInfo.blockView.method_24852(quad.lightFace(), hasShade);
            if (faceShade != 1.0f) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, class_9848.method_61321((int)quad.color(i), (float)faceShade));
                }
            }
        }
    }

    private float normalShade(float normalX, float normalY, float normalZ, boolean hasShade) {
        float sum = 0.0f;
        float div = 0.0f;
        if (normalX > 0.0f) {
            sum += normalX * this.blockInfo.blockView.method_24852(class_2350.field_11034, hasShade);
            div += normalX;
        } else if (normalX < 0.0f) {
            sum += -normalX * this.blockInfo.blockView.method_24852(class_2350.field_11039, hasShade);
            div -= normalX;
        }
        if (normalY > 0.0f) {
            sum += normalY * this.blockInfo.blockView.method_24852(class_2350.field_11036, hasShade);
            div += normalY;
        } else if (normalY < 0.0f) {
            sum += -normalY * this.blockInfo.blockView.method_24852(class_2350.field_11033, hasShade);
            div -= normalY;
        }
        if (normalZ > 0.0f) {
            sum += normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11035, hasShade);
            div += normalZ;
        } else if (normalZ < 0.0f) {
            sum += -normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11043, hasShade);
            div -= normalZ;
        }
        return sum / div;
    }

    private int flatLight(MutableQuadViewImpl quad) {
        class_2680 blockState = this.blockInfo.blockState;
        class_2338 pos = this.blockInfo.blockPos;
        this.lightPos.method_10101((class_2382)pos);
        if (quad.cullFace() != null) {
            this.lightPos.method_10098(quad.cullFace());
        } else {
            int flags = quad.geometryFlags();
            if ((flags & 4) != 0 || (flags & 2) != 0 && blockState.method_26234((class_1922)this.blockInfo.blockView, pos)) {
                this.lightPos.method_10098(quad.lightFace());
            }
        }
        return this.lightDataProvider.light((class_2338)this.lightPos, blockState);
    }
}

