/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.tag;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.impl.tag.SimpleRegistryExtension;
import net.fabricmc.fabric.impl.tag.TagAliasEnabledRegistryWrapper;
import net.fabricmc.fabric.mixin.tag.SimpleRegistryTagLookup2Accessor;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_2370.class})
abstract class MappedRegistryMixin<T>
implements SimpleRegistryExtension,
TagAliasEnabledRegistryWrapper {
    @Unique
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-tag-api-v1");
    @Unique
    private Map<class_6862<?>, Set<class_6862<?>>> pendingTagAliasGroups;
    @Shadow
    @Final
    private class_5321<? extends class_2378<T>> field_41126;
    @Shadow
    class_2370.class_10105<T> field_53687;

    MappedRegistryMixin() {
    }

    @Shadow
    protected abstract class_6885.class_6888<T> method_40562(class_6862<T> var1);

    @Shadow
    abstract void method_62692();

    @Shadow
    public abstract class_5321<? extends class_2378<T>> method_46765();

    @Override
    public void fabric_loadTagAliases(Map<class_6862<?>, Set<class_6862<?>>> aliasGroups) {
        this.pendingTagAliasGroups = aliasGroups;
    }

    @Override
    public void fabric_applyPendingTagAliases() {
        if (this.pendingTagAliasGroups == null) {
            return;
        }
        Set uniqueAliasGroups = Sets.newIdentityHashSet();
        uniqueAliasGroups.addAll(this.pendingTagAliasGroups.values());
        for (Set aliasGroup : uniqueAliasGroups) {
            Set entries = Sets.newIdentityHashSet();
            for (class_6862 tag : aliasGroup) {
                class_6885.class_6888 entryList = this.field_53687.method_62698(tag).orElse(null);
                if (entryList != null) {
                    entries.addAll(entryList.field_36460);
                    continue;
                }
                LOGGER.info("[Fabric] Creating a new empty tag {} for unknown tag used in a tag alias group in {}", (Object)tag.comp_327(), (Object)tag.comp_326().method_29177());
                Map tagMap = ((SimpleRegistryTagLookup2Accessor)this.field_53687).fabric_getTagMap();
                if (!(tagMap instanceof HashMap)) {
                    tagMap = new HashMap(tagMap);
                    ((SimpleRegistryTagLookup2Accessor)this.field_53687).fabric_setTagMap(tagMap);
                }
                tagMap.put(tag, this.method_40562(tag));
            }
            List entriesAsList = List.copyOf(entries);
            for (class_6862 tag : aliasGroup) {
                class_6885.class_6888 entryList = (class_6885.class_6888)this.field_53687.method_62698(tag).orElseThrow();
                entryList.field_36460 = entriesAsList;
            }
        }
        LOGGER.debug("[Fabric] Loaded {} tag alias groups for {}", (Object)uniqueAliasGroups.size(), (Object)this.field_41126.method_29177());
        this.pendingTagAliasGroups = null;
    }

    @Override
    public void fabric_refreshTags() {
        this.method_62692();
    }
}

